SET NOCOUNT ON

IF NOT EXISTS(
	SELECT 
		ID 
	FROM 
		SYSOBJECTS 
	WHERE 
		NAME = 'EST_PROD' AND XTYPE = 'U')
BEGIN
	SET NOCOUNT OFF
	RAISERROR('A TABELA NA QUAL O CAMPO SER ADICIONADO NO FOI ENCONTRADA NO BANCO DE DADOS.',16,1)
END
ELSE
BEGIN
	IF EXISTS (
		SELECT
			* 
		FROM 
			SYSCOLUMNS 
		WHERE 
			NAME = 'RECEITA_FLAG_TIPO_OBRIGATOREIDADE'
			AND ID IN (
				SELECT 
					ID 
				FROM 
					SYSOBJECTS 
				WHERE 
					NAME = 'EST_PROD' AND XTYPE = 'U')
		)

		BEGIN
			/*
				0 - NO DEFINIDO / NO OBRIGATORIO
				1 - NA RECEITA, OBRIGATORIO DADOS DO COMPRADOR
				2 - NA RECEITA, OBRIGATORIO DADOS DO PACIENTE
				3 - NA RECEITA, OBRIGATORIO DADOS DO COMPRADOR E PACIENTE
			*/
			UPDATE EST_PROD SET RECEITA_FLAG_TIPO_OBRIGATOREIDADE = 0 WHERE CONTROLE_SNGPC = 0;
			PRINT 'CAMPO RECEITA_FLAG_TIPO_OBRIGATOREIDADE ATUALIZADO PARA PRODUTOS NO CONTROLADOS PELO SNGPC.'
			UPDATE EST_PROD SET RECEITA_FLAG_TIPO_OBRIGATOREIDADE = 1 WHERE FLAG_PRODUTO_CONTROLADO = 1;
			PRINT 'CAMPO RECEITA_FLAG_TIPO_OBRIGATOREIDADE ATUALIZADO PARA PRODUTOS DO TIPO CONTROLADO.'
			UPDATE EST_PROD SET RECEITA_FLAG_TIPO_OBRIGATOREIDADE = 2 WHERE ANTIBIOTICO = 1;
			PRINT 'CAMPO RECEITA_FLAG_TIPO_OBRIGATOREIDADE ATUALIZADO PARA PRODUTOS DO TIPO ANTIBIOTICO.'
		END
	SET NOCOUNT OFF
END